// Import the HTTP module from k6 to allow making HTTP requests
import http from "k6/http";
// Import the sleep function to pause between iterations
import { sleep } from "k6";

// Export test options that define how the load test runs
export let options = {
  stages: [
    // Ramp up to 20 virtual users over 30 seconds
    { duration: "30s", target: 20 },
    // Increase to 50 virtual users over 1 minute
    { duration: "1m", target: 50 },
    // Ramp back down to 0 users over 30 seconds (cool-down period)
    { duration: "30s", target: 0 },
  ],
};

// Default function executed by each virtual user repeatedly
export default function () {
  // The API endpoint you want to test
  const url =
    "https://shawermah.store/api/products?category=6925a86623f3a8dcdb91b71a";

  // Send an HTTP GET request to the URL
  const res = http.get(url, {
    headers: {
      authorization:
        "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY5MTRkNDIwMDJiZmZjYTE2OWFhYWNhYyIsInBob25lIjoiMDc5OTYzNTU4MiIsInJvbGUiOiJhZG1pbiIsImlhdCI6MTc2NTU1Njg3MywiZXhwIjoxNzY1NjQzMjczfQ.4JCnRKgjaTpY0H_YZ_GXBDAESwt9m4d6A0BC3f37eFM",
    },
  });

  // Check if the response status is not 200 (success)
  // If not, print an error message with status and body
  if (res.status !== 200) {
    console.error(`❌ Failed with status ${res.status}: ${res.body}`);
  }

  // Sleep for 1 second before running the next iteration
  sleep(1);
}

//  const randomProduct = productIds[Math.floor(Math.random() * productIds.length)];

// const productIds = [
//   "68e387dcfd38d4289397b2af",
//   "68e387dcfd38d4289397b2b6",
//   "68e387dcfd38d4289397b2bc",
// ];

// const payload = JSON.stringify({
//   products: [{ productId: randomProduct, quantity: 1 }],
//   userId: "68e0faefbdae81658966916a",
//   shippingAddress: "68d860d988e6a681633f513b",
//   paymentMethod: "cash",
//   orderType: "delivery",
//   userDetails: {
//     name: "Load Test User",
//   },
// });

// const params = {
//   headers: { "Content-Type": "application/json" },
// };
